<?php
/*
Template Name: Password Restore
Template Post Type: page
*/
is_user_logged_in() ? wp_redirect('/') : ''; //prevent logged in users

add_filter('body_class', function ($classes) {
    $classes[] = 'sign_2';
    return $classes;
});

get_header();
?>


<main class="sign_in">
    <div class="wrapper">
        <div class="content">
            <div class="wrapper_main">
                <div class="container">
                    <div class="login_page">
                        <div class="title_wrapper">
                            <div class="icon_title">
                                <?php include locate_template('assets/img/icon-title-13.svg'); ?>
                            </div>
                            <h2 class="title"><?php the_title() ?></h2>
                        </div>
                        <div class="sub_title"><?php the_field('subtitle') ?></div>
                        <?php
                        $slug = isset($_GET['key'], $_GET['login']) ? 'new' : 'send';
                        get_template_part('template-parts/content/password-restore', $slug);
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php get_footer() ?>